const Discord = require('discord.js');
const client = new Discord.Client({ partials: ['MESSAGE', 'CHANNEL', 'REACTION'] });
const fetch = require('node-fetch');
let settings = { method: "Get" };
let config = require('./config');

let verifyEmbed = new Discord.MessageEmbed()
  .setColor('#FF0000')
  .setTitle(`Verification Instructions`)
  .setURL(config.websiteURL)
  .setDescription('The instructions to link your accounts to recieve your Discord Kit!')
  .setAuthor('Ryz0r', 'https://cdn.discordapp.com/avatars/140496445798219776/63c56af056e2a07b4d7c0d438f114ab8.png', 'https://ryz.sh/')
  .setFooter(config.websiteURL + ' Simple Link Bot by Ryz0r - v1.0.0')
  .setThumbnail(config.logoURL)
  .addField('Step 1', 'Navigate to ' + config.websiteURL + ' or click [here](' + config.websiteURL + ').')
  .addField('Step 2', 'Click Login with Discord, and then login with your current Discord account.')
  .addField('Step 3', 'Click Login with Steam, and then login with your current Steam account.')
  .addField('Step 4', 'Ensure both Steam and Discord say linked, and if so - you are done!');
  
client.login(config.botToken);

function updateNitro(discordID, status) {
    fetch(config.websiteURL + "api.php?action=updateNitro&status=" + status + "&secret=" + config.secret + "&id=" + discordID, settings)
        .then(res => res.text())
        .then(text => {
            try {
                const data = JSON.parse(text);
                //console.log(data);
            } catch(err) {
                console.log(err);
            }
        }).catch(err => console.log(err));
}

function checkNitro() {
    fetch(config.websiteURL + "api.php?action=listNitro&secret=" + config.secret + "", settings)
        .then(res => res.text())
        .then(text => {
            try {
                const json = JSON.parse(text);
                console.log("Running nitro checker.");
                for (i = 0; i < json.Result.length; i++) {
                    var member = client.guilds.cache.first().members.cache.get(json.Result[i].discord_id);
                    if(!member.premiumSince) {
                        console.log(`Member has nitro ${member.user.id}, but is not premium.`)
                        updateNitro(member.user.id, 0)
                    }
                }
            } catch(err) {
               console.log(err);
            }
    }).catch(err => console.log(err));
}

client.on("guildMemberAdd", member => {
    fetch(config.websiteURL + "api.php?action=findByDiscord&id=" + member.user.id +"&secret=" + config.secret + "", settings).then(res => res.text()).then((res) => {
      if(res.toString().includes("No users")) return;

      vRole = member.guild.roles.cache.find(r => r.id === config.verifiedRoleID);
      member.roles.add(vRole);
    });
});

client.on('ready', () => {
  console.log(`Logged in as ${client.user.tag}! Bot is ready!`);

  client.guilds.cache.first().members.fetch();

  client.setInterval(() => {
    fetch(config.websiteURL + "api.php?action=count&secret=" + config.secret + "", settings)
        .then(res => res.json())
        .then((json) => {
            client.user.setActivity(json.Total.toString() + " Verified!", { type: 'WATCHING' }).catch(console.error);
         }).catch(err => console.log(err));
    }, 30000);
	
	client.setInterval(() => {

        client.guilds.cache.first().members.cache.filter(member => member.fetch() && member.premiumSince).each(member => updateNitro(member.user.id, 1));

    }, 30000);

    if (config.syncNames) {
        client.setInterval(() => {
            client.guilds.cache.first().members.cache.filter(member => member.fetch() && member.roles.cache.has(config.verifiedRoleID)).each(member => {
                fetch(config.websiteURL + "api.php?action=getSteam&id=" + member.user.id + "&secret=" + config.secret + "", settings)
                    .then(res => res.json())
                    .then((json) => {
                        if (json.toString().toLowerCase().includes("false")) return;

                        if (!client.guilds.cache.first().me.hasPermission('MANAGE_NICKNAMES')) return console.log('I don\'t have permission to change nicknames!');
                        if (member.id === client.guilds.cache.first().ownerID) return;
                        member.setNickname(json).catch(err => {
                            console.log(`Error Setting Nickname\n${err}`);
                        });
                    });
            });
        }, 34000);
    }

    client.setInterval(() => {

        checkNitro();

    }, 600000);
});

client.on("guildMemberRemove", (member) => {

  fetch(config.websiteURL + "api.php?action=remove&secret=" + config.secret + "&id=" + member.id, settings)
        .then(res => res.json())
        .then((json) => {
            console.log(json);
    }).catch(err => console.log(err));
  
});

client.on("message", async function(message) {

    if(message.author.bot) return;
    if (message.channel.type == "dm") return;
    
    if(message.content.toLowerCase().includes("auth") || message.content.toLowerCase().includes("verify") || message.content.toLowerCase().includes("link")) {
        if (config.sendMessages) {
            message.channel.send(`Hey ${message.author}, it seems like you are trying to verify your accounts. Instructions below will delete in 30 seconds.`)
            message.channel.send(verifyEmbed).then(msg => msg.delete({timeout: 30000}));
        }
    }

    if(message.member.hasPermission("ADMINISTRATOR") || message.member.roles.cache.has(config.staffAccessRoleID)) {

        var prefixChar = message.content[0];
        if (config.prefixes.includes(prefixChar)) {
            message.content = message.content.replace(prefixChar, '');
            args = message.content.toString().split(" ");

            if (args[0] == '') {
                args.splice(0, 1);
            }

            switch(args[0]) {
                case "search":
                    if(!args[1]) {
                        message.channel.send("**You have not provided any user information to search.**");
                        return;
                    }

                    searchID = "";
                    searchType = "";
                    if (message.mentions.users.first()) {
                        searchID = message.mentions.users.first().id;
                        searchType = "Discord";
                    } else if (args[1].length == 17 && args[1].startsWith("7656119")) {
                        searchID = args[1];
                        searchType = "Steam";
                    } else if (args[1].length > 15 && !args[1].startsWith("7656119")) {
                        searchID = args[1];
                        searchType = "Discord";
                    } else {
                        message.reply("not a valid search ID.");
                        return;
                    }

                    if (searchType === "Discord") {
                        fetch(config.websiteURL + "api.php?action=findByDiscord&id=" + searchID + "&secret=" + config.secret + "", settings)
                        .then(res => res.text())
                        .then((res) => {
                            if(res.toString().includes("No users")) {
                                    message.channel.send("No users with a linked account.");
                                    return;
                            }

                            let theEmbed = new Discord.MessageEmbed()
                                .setColor('#4286f4')
                                .setTitle(`User Lookup Results`)
                                .setThumbnail(config.logoURL)
                                .addField("Discord ID", searchID, true)
                                .addField("Steam ID", res, true);
                            
                            message.reply(theEmbed);
                        });
                    } else if (searchType === "Steam") {
                        fetch(config.websiteURL + "api.php?action=findBySteam&id=" + searchID + "&secret=" + config.secret + "", settings)
                        .then(res => res.text())
                        .then((res) => {
                            if(res.toString().includes("No users")) {
                                    message.channel.send("No users with a linked account.");
                                    return;
                            }

                            let theEmbed = new Discord.MessageEmbed()
                                .setColor('#4286f4')
                                .setTitle(`User Lookup Results`)
                                .setThumbnail(config.logoURL)
                                .addField("Discord ID", `${res}`, true)
                                .addField("Steam ID", searchID, true);
                            
                            message.reply(theEmbed);
                        });
                    }
                break; 

                case "count":
                    fetch(config.websiteURL + "api.php?action=count&secret=" + config.secret + "", settings)
                        .then(res => res.json())
                        .then((json) => {
                            message.channel.send("There are " + json.Total + " total users verified on " + config.serverName + ".");
                        }).catch(err => console.log(err));
                break;

                case "link":
                case "verify":
                case "auth":
                    message.channel.send(verifyEmbed);
                break;

                case "help":
                    message.channel.send("Current Commands\n```search (discord id/tag/steam id) - searches for user information in linking database\nhelp - simple help document\ncount - lists number of verified\nlink/verify/auth - will display a helpful popup on how to verify```");
                    break;
            }
        }
    }
});